<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Services\UserApplication\ShowDetails\Response\Version2;

use Sso\WebserviceBundle\Api\ApiManagerInterface;
use Sso\WebserviceBundle\ErrorHandler\ErrorHandlerInterface;
use Sso\WebserviceBundle\Services\UserApplication\ShowDetails\ResponseData\User as ResponseDataUser;
use Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Response\Version2\ResponseBuilder;
use Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Response\Version2\Factory;
use JMS\Serializer\SerializerBuilder;
use Sso\WebserviceBundle\Entity\Webservice\Type\User as UserModel;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class ResponseBuilderTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Tests\Services\User\Show\Response\Version2
 */
class ResponseBuilderTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var ApiManagerInterface
     */
    private $apiManager;

    protected function setUp()
    {
        $this->apiManager = $this->createMock(ApiManagerInterface::class);
    }

    /**
     * @param array $userData
     */
    public function testSetResponseSuccess()
    {
        $user = new ResponseDataUser();
        $arrayCollection = new ArrayCollection();
        $arrayCollection->add( 'TestApplication' );
        $user->setFromUserModel($this->userDataProvider(), $arrayCollection);

        $responseBuilder = $this->factoryResponseBuilder();
        $responseBuilder->setResponse($user);

        self::assertAttributeEquals($user, 'responseData', $responseBuilder);
    }

    /**
     * @return ResponseBuilder
     */
    private function factoryResponseBuilder()
    {
        $serializer = SerializerBuilder::create()->build();
        $factory = new Factory($this->apiManager);
        $errorHandler = $this->createMock(ErrorHandlerInterface::class);
        $responseBuilder = new ResponseBuilder($serializer, $factory, $errorHandler);

        return $responseBuilder;
    }

    /**
     * @return array
     */
    public function userDataProvider()
    {
        $validator = $this->createMock(ValidatorInterface::class);
        $faker = \Faker\Factory::create();
        $user = new UserModel($validator);
        $user->setGuid($faker->uuid);
        $user->setUsername($faker->userName);
        $user->setEmail($faker->email);
        $user->setFirstname($faker->firstName);
        $user->setLastname($faker->lastName);
        $user->setActive(rand(0, 1));
        $user->setDeleted(rand(0, 1));
        $user->setAuthId($faker->sha256);
        $user->setLdapSearchAttributes($faker->sha256);
        $user->setLdapSearchValue($faker->sha256);
        $user->setMfaEnabled(true);
        $user->setLoginSuccess();


        return $user;
    }


}
