<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Services\UserApplication\ShowDetails\ResponseData;

use Sso\WebserviceBundle\Api\ApiManagerInterface;
use Sso\WebserviceBundle\Services\UserApplication\ShowDetails\ResponseData\User as ResponseDataUser;
use Sso\WebserviceBundle\Entity\Webservice\Type\User as UserModel;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class UserTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Tests\Services\User\Show\ResponseData
 */
class UserTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var ApiManagerInterface
     */
    private $apiManager;

    /**
     * @param UserModel $userModel
     */
    public function testCreateFromArraySuccess()
    {
        $userData = $this->userDataProvider();
        $user = new ResponseDataUser();
        $arrayCollection = new ArrayCollection();
        $arrayCollection->add( 'TestApplication' );
        $user = $user->setFromUserModel($userData, $arrayCollection);

        self::assertSame($userData->getUsername(), $user->getUsername());
    }

    protected function setUp()
    {
        $this->apiManager = $this->createMock(ApiManagerInterface::class);
    }

    /**
     * @return UserModel
     */
    public function userDataProvider()
    {
        $validator = $this->createMock(ValidatorInterface::class);
        $faker = \Faker\Factory::create();
        $user = new UserModel($validator);
        $user->setGuid($faker->uuid);
        $user->setUsername($faker->userName);
        $user->setEmail($faker->email);
        $user->setFirstname($faker->firstName);
        $user->setLastname($faker->lastName);
        $user->setActive(rand(0, 1));
        $user->setDeleted(rand(0, 1));
        $user->setAuthId($faker->sha256);
        $user->setLdapSearchAttributes($faker->sha256);
        $user->setLdapSearchValue($faker->sha256);
        $user->setMfaEnabled(true);
        $user->setLoginSuccess();
        return $user;
    }

}
