<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Services\UserSearch\Advanced\Request\Version2;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\WebserviceBundle\Api\ApiManagerInterface;
use JMS\Serializer\SerializerInterface;
use Sso\WebserviceBundle\Services\UserSearch\Advanced\Request\Version2 as Model;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Tests\Services
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManagerInterface
     */
    private $apiManager;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = static::$kernel->getContainer()->get('service_api_manager');
        $this->serializer = $this->apiManager->serializer();
    }

    public function testSerialize()
    {
        $request = new Model\Request();
        $userSearch = new Model\UserSearch();
        $advanced = new Model\Advanced();
        $advanced->setOffset(0);
        $advanced->setLimit(100);
        $advanced->setOrderBy('createdAt');
        $advanced->setOrderDir('ASC');
        $advanced->setFullResponse(1);

        //first filter
        $userTypeOne = new Model\UserType();
        $userTypeOne->setGuid('TestGuid');
        $userTypeOne->setEmail('my@email.de');
        $userTypeOne->setUsername('Username');
        $userTypeOne->setFirstname('Firstname');
        $userTypeOne->setLastname('Lastname');
        $userTypeOne->setActive(1);
        $userTypeOne->setDeleted(1);
        $userTypeOne->setMfaEnabled(1);
        $userTypeOne->setCreatedAt(new \DateTime("1976-04-23T00:05:00+01:00"));
        $filterOne = new Model\Filter();
        $filterOne->setStrategy('EQUAL');
        $filterOne->setOperator('OR');
        $filterOne->setUserType($userTypeOne);


        //second filter
        $appTypeTwo = new Model\ApplicationType();
        $appTypeTwo->setName('ApplicationName');
        $appTypeTwo->setActive(1);

        $filterTwo= new Model\Filter();
        $filterTwo->setStrategy('EQUAL');
        $filterTwo->setOperator('AND');
        $filterTwo->setApplicationType($appTypeTwo);

        //third filter
        $appTypeThird = new Model\ApplicationType();
        $appTypeThird->setName('ApplicationName');
        $appTypeThird->setActive(1);

        $attributeTypeThird = new Model\AttributeType();
        $attributeTypeThird->setName('AttributeName');
        $attributeTypeThird->setActive(1);
        $attributeTypeThird->setValue("AttributeValue");
        $appTypeThird->setAttributeType($attributeTypeThird);

        $roleTypeThird = new Model\RoleType();
        $roleTypeThird->setName('MyRoleName');
        $roleTypeThird->setActive(1);
        $appTypeThird->setRoleType($roleTypeThird);

        $filterThird= new Model\Filter();
        $filterThird->setStrategy('EQUAL');
        $filterThird->setOperator('AND');
        $filterThird->setApplicationType($appTypeThird);

        //now a very complex filter with filters
        $filtersComplex = new Model\Filters();
        $filtersComplex->addFilter($filterOne);
        $filtersComplex->addFilter($filterTwo);
        $filterComplex= new Model\Filter();
        $filterComplex->setStrategy('EQUAL');
        $filterComplex->setOperator('AND');
        $filterComplex->setFilters($filtersComplex);

        $filters = new Model\Filters();
        $filters->addFilter($filterOne);
        $filters->addFilter($filterTwo);
        $filters->addFilter($filterThird);
        $filters->addFilter($filterComplex);

        $advanced->setFilters($filters);
        $userSearch->setAdvanced($advanced);
        $request->setUserSearch($userSearch);

        $xml = $this->serializer->serialize($request, "xml");

        $this->assertXmlStringEqualsXmlString($this->getRequestBody(), $xml);

    }

    /**
     * @return string
     */
    private function getRequestBody()
    {
        return '<?xml version="1.0"?>
                <SsoRequest>
                  <UserSearch>
                    <Advanced>
                      <Offset>0</Offset>
                      <Limit>100</Limit>
                      <OrderBy>createdAt</OrderBy>
                      <OrderDir>ASC</OrderDir>
                      <FullResponse>1</FullResponse>
                      <Filters>
                        <Filter>
                            <Strategy>EQUAL</Strategy>
                            <Operator>OR</Operator>
                            <UserType>
                                <Guid>TestGuid</Guid>
                                <Email>my@email.de</Email>
                                <Username>Username</Username>
                                <Firstname>Firstname</Firstname>
                                <Lastname>Lastname</Lastname>
                                <Active>1</Active>
                                <Deleted>1</Deleted>
                                <MfaEnabled>1</MfaEnabled>
                                <CreatedAt>1976-04-23T00:05:00+01:00</CreatedAt>
                            </UserType>
                        </Filter>
                        <Filter>
                            <Strategy>EQUAL</Strategy>
                            <Operator>AND</Operator>
                            <ApplicationType>
                                <Name>ApplicationName</Name>
                                <Active>1</Active>
                            </ApplicationType>
                        </Filter>
                        <Filter>
                          <Strategy>EQUAL</Strategy>
                          <Operator>AND</Operator>
                          <ApplicationType>
                            <Name>ApplicationName</Name>
                            <Active>1</Active>
                            <AttributeType>
                              <Name>AttributeName</Name>
                              <Value>AttributeValue</Value>
                              <Active>1</Active>
                            </AttributeType>
                            <RoleType>
                              <Name>MyRoleName</Name>
                              <Active>1</Active>
                            </RoleType>
                          </ApplicationType>
                        </Filter>
                        <Filter>
                          <Strategy>EQUAL</Strategy>
                          <Operator>AND</Operator>
                          <Filters>
                            <Filter>
                              <Strategy>EQUAL</Strategy>
                              <Operator>OR</Operator>
                              <UserType>
                                <Guid>TestGuid</Guid>
                                <Email>my@email.de</Email>
                                <Username>Username</Username>
                                <Firstname>Firstname</Firstname>
                                <Lastname>Lastname</Lastname>
                                <Active>1</Active>
                                <Deleted>1</Deleted>
                                <MfaEnabled>1</MfaEnabled>
                                <CreatedAt>1976-04-23T00:05:00+01:00</CreatedAt>
                              </UserType>
                            </Filter>
                            <Filter>
                              <Strategy>EQUAL</Strategy>
                              <Operator>AND</Operator>
                              <ApplicationType>
                                <Name>ApplicationName</Name>
                                <Active>1</Active>
                              </ApplicationType>
                            </Filter>
                          </Filters>
                        </Filter>
                      </Filters>
                    </Advanced>
                  </UserSearch>
                </SsoRequest>';
    }
}
