<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Services\UserSearch\FindByApplicationRole;

use Sso\WebserviceBundle\Api\ApiManagerInterface;
use Sso\WebserviceBundle\Database\Manager as DatabaseManager;
use Sso\WebserviceBundle\ErrorHandler\ErrorHandlerInterface;
use Sso\WebserviceBundle\Services\ApiVersionInflectorInterface;
use Sso\WebserviceBundle\Services\UserSearch\FindByApplicationRole\Factory;
use Sso\WebserviceBundle\Services\UserSearch\FindByApplicationRole\Handler;
use Sso\WebserviceBundle\Services\RequestInterface;
use Sso\WebserviceBundle\Services\ResponseBuilderInterface;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class HandlerTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Tests\Services\User\Show
 */
class HandlerTest extends WebTestCase
{
    /**
     * @var DatabaseManager
     */
    private $database;

    /**
     * @var ApiManagerInterface
     */
    private $apiManager;

    public function testHandleSuccess()
    {
        $faker = \Faker\Factory::create();
        $email = $faker->email;

        $apiVersion = 2;

        $apiVersionInflector = $this->createMock(ApiVersionInflectorInterface::class);
        $apiVersionInflector
            ->method('inflect')
            ->will(self::returnCallback(function ($namespace, $classname) use ($apiVersion) {
                return $namespace.'\\Version'.$apiVersion.'\\'.$classname;
            }));
        $factory = new Factory($this->apiManager, $apiVersionInflector);

        $errorHandler = $this->createMock(ErrorHandlerInterface::class);
        $errorHandler
            ->method('hasErrors')
            ->will(self::returnValue(true));

        $request = $this->createMock(RequestInterface::class);
        $request
            ->expects(self::once())
            ->method('getRequestBody')
            ->will(self::returnValue($this->getRequestBody($email)));

        $handler = new Handler($factory, $this->database, $errorHandler);

        $responseBuilder = $handler->handle($request);

        self::assertInstanceOf(ResponseBuilderInterface::class, $responseBuilder);
    }

    /**
     * @param string $identifier
     * @return string
     */
    private function getRequestBody($identifier)
    {
        return '<?xml version="1.0"?>
                <SsoRequest>
                  <UserSearch>
                    <FindByApplicationRole>
                      <Key>
                        <ApplicationType>
                          <Name>jochen</Name>
                          <Active>1</Active>
                        </ApplicationType>
                        <AttributeType>
                          <Name>AttributK&#xE4;se</Name>
                          <Value>K&#xE4;sebrot</Value>
                        </AttributeType>
                      </Key>
                    </FindByApplicationRole>
                  </UserSearch>
                </SsoRequest>';
    }

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = static::$kernel->getContainer()->get('service_api_manager');

        $this->database  = $this->getMockBuilder(DatabaseManager::class)
            ->disableOriginalConstructor()
            ->setMethods(array('webservice', 'application','getApplicationByName'))
            ->getMock();
        $this->database->expects($this->any())
            ->method('webservice')
            ->will($this->returnSelf());
        $this->database->expects($this->any())
            ->method('application')
            ->will($this->returnSelf());
        $this->database->expects($this->any())
            ->method('getApplicationByName')
            ->will($this->returnValue(false));
    }
}
