<?php

namespace Sso\WebserviceBundle\Tests;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\WebserviceBundle\Api\Manager as ApiManager;

class WebserviceTestCase extends WebTestCase
{
    /**
     * @var ApiManager
     */
    protected $apiM;
    /**
     * Webservice service token
     *
     * @var string
     */
    protected $ServiceToken = 'V2030cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa';

    /**
     * Webservice service name
     *
     * @var string
     */
    protected $ServiceName = 'MyService';

    /**
     * Webservice country code
     *
     * @var string
     */
    protected $ServiceCountryCode = 'DE';

    /**
     * Webservice user identifier
     *
     * @var string
     */
    protected $idpUserIdentifier = null;

    /**
     * @var string
     */
    protected $idpTestUsername = "user-api-grant-access";

    /**
     * @var string
     */
    protected $idpTestUserPwd = 'SsO#12Test';

    /**
     * Application name for testing
     *
     * @var string
     */
    protected $ApplicationName;

    /**
     * Attribute name for testing
     *
     * @var string
     */
    protected $AttributeName;

    /**
     * Role name for testing
     *
     * @var string
     */
    protected $RoleName;

    /**
     * Webservice country code
     *
     * @var string
     */
    protected $userName = 'userNameString';

    /**
     * Username for testing
     *
     * @var string
     */
    protected $Username;

    /**
     * Email for testing
     *
     * @var string
     */
    protected $Email;

    /**
     * WebserviceTestCase constructor.
     * @param null $name
     * @param array $data
     * @param string $dataName
     */
    public function __construct($name = null, array $data = [], $dataName = '')
    {
        parent::__construct($name, $data, $dataName);
        date_default_timezone_set('Europe/Berlin');

        $client = static::createClient();
        $container = $client->getContainer();
        $logger = $container->get('logger');
        $this->apiM = new ApiManager($container, $logger);
    }

    protected function tearDown()
    {
        parent::tearDown();
        $this->apiM = null;
        //gc_collect_cycles();
    }
}
