<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Validator\Constraints;

use Doctrine\Common\Annotations\Annotation\Target;
use Symfony\Component\Validator\Constraint;

/**
 * Class PasswordPolicy
 *
 * @Annotation
 * @Target({"CLASS", "ANNOTATION"})
 *
 * @package Sso\WebserviceBundle\Validator\Constraints
 */
class PasswordPolicy extends Constraint
{
    /**
     * @var string
     */
    public $passwordGetter;

    /**
     * @var string
     */
    public $previousPasswordGetter;

    /**
     * @var string
     */
    public $service = 'sso_webservice.password_policy_validator';

    /**
     * @var string
     */
    public $message = 'Password does not satisfy policy: {{ violations }}';

    /**
     * @var string|null
     */
    public $errorPath = null;

    /**
     * The validator must be defined as a service with this name.
     *
     * @return string
     */
    public function validatedBy()
    {
        return $this->service;
    }

    /**
     * @return array|string
     */
    public function getTargets()
    {
        return self::CLASS_CONSTRAINT;
    }
}
