<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace LifeStyle\DH\AccessControlBundle\Authorization;

/**
 * Class UserScopes
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package LifeStyle\DH\AccessControlBundle\Authorization
 */
class UserScopes
{
    /**
     * @var bool
     */
    private $globalHrManager;

    /**
     * @var string
     */
    private $userId;

    /**
     * @var array
     */
    private $scopeIds;

    /**
     * @var string
     */
    private $applicationId;

    /**
     * @var array
     */
    private $applicationAttributeIds;

    /**
     * UserScopes constructor.
     * @param bool $globalHrManager
     * @param string $userId
     * @param array $scopeIds
     * @param string $applicationId
     * @param array $applicationAttributeIds
     */
    public function __construct(
        bool $globalHrManager,
        string $userId,
        array $scopeIds,
        string $applicationId,
        array $applicationAttributeIds
    ) {
        $this->globalHrManager = $globalHrManager;
        $this->userId = $userId;
        $this->scopeIds = $scopeIds;
        $this->applicationId = $applicationId;
        $this->applicationAttributeIds = $applicationAttributeIds;
    }

    /**
     * @return bool
     */
    public function isGlobalHrManager(): bool
    {
        return $this->globalHrManager;
    }

    /**
     * @return string
     */
    public function getUserId(): string
    {
        return $this->userId;
    }

    /**
     * @return array
     */
    public function getScopeIds(): array
    {
        return $this->scopeIds;
    }

    /**
     * @return string
     */
    public function getApplicationId(): string
    {
        return $this->applicationId;
    }

    /**
     * @return array
     */
    public function getApplicationAttributeIds(): array
    {
        return $this->applicationAttributeIds;
    }
}
