<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace LifeStyle\DH\AccessControlBundle\Configuration;

/**
 * Class ClientConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package LifeStyle\DH\AccessControlBundle\Configuration
 */
class ClientConfiguration
{
    /**
     * @var string
     */
    private $authToken;

    /**
     * @var string
     */
    private $baseUrl;

    /**
     * ClientConfiguration constructor.
     * @param string $authToken
     * @param string $baseUrl
     */
    public function __construct(string $authToken, string $baseUrl)
    {
        $this->authToken = $authToken;
        $this->baseUrl = $baseUrl;
    }

    /**
     * @return string
     */
    public function getAuthToken(): string
    {
        return $this->authToken;
    }

    /**
     * @return string
     */
    public function getBaseUrl(): string
    {
        return $this->baseUrl;
    }
}
