<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\DH\AttributeGeneratorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class DhEmployeeId
 *
 * @deprecated Will be removed in next version
 * @ORM\Table(name="dh_employee_id")
 * @ORM\Entity()
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\DH\AttributeGeneratorBundle\Entity
 */
class DhEmployeeId
{
    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\Column(type="integer", nullable=false)
     */
    private $employeeId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime", name="created_at")
     */
    private $createdAt;

    /**
     * DhEmployeeId constructor.
     * @param int $employeeId
     */
    private function __construct(int $employeeId)
    {
        $this->employeeId = $employeeId;
        $this->createdAt = new \DateTime();
    }

    /**
     * @param int $employeeId
     * @return DhEmployeeId
     */
    public static function create(int $employeeId): DhEmployeeId
    {
        return new self($employeeId);
    }

    /**
     * @return int
     */
    public function getEmployeeId(): int
    {
        return $this->employeeId;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt(): \DateTime
    {
        return $this->createdAt;
    }
}
