<?php

use Symfony\Component\HttpFoundation\Request;

/** @var \Composer\Autoload\ClassLoader $loader */
$loader = require __DIR__ . '/../app/autoload.php';
include_once __DIR__ . '/../app/bootstrap.php.cache';

$kernel = new AppKernel('aws_prod', false);
$kernel->loadClassCache();

// Add Loadbalancers to detect http(s)
if (
    array_key_exists('TRUSTED_PROXIES', $_SERVER) &&
    ($trustedProxies = explode(',', $_SERVER['TRUSTED_PROXIES']))
) {
    Request::setTrustedProxies($trustedProxies);
}

$request = Request::createFromGlobals();
$response = $kernel->handle($request);
$response->send();
$kernel->terminate($request, $response);
