# Installation

This instruction describes the installation for the ls-sso-uws (user-webservice).

## Local Installation

### Requirements

- PHP 7.1.3
- Apache 2.4
- MySql 5.7

### Configure application

```shell script
cp app/config/parameters.yml.dist app/config/parameters.yml
```

Edit `app/config/parameters.yml` and adjust values to your installation.

### Prepare database

Create 3 databases (encoding: utf8mb4 / utf8mb4_unicode_ci):

```
CREATE DATABASE IF NOT EXISTS ws_backend CHARACTER SET = 'utf8mb4' COLLATE = 'utf8mb4_unicode_ci';
CREATE DATABASE IF NOT EXISTS ws_data CHARACTER SET = 'utf8mb4' COLLATE = 'utf8mb4_unicode_ci';
CREATE DATABASE IF NOT EXISTS ws_sp CHARACTER SET = 'utf8mb4' COLLATE = 'utf8mb4_unicode_ci';
```

Run doctrine migrations. Don't change order of commands:

```shell script
php app/console doctrine:migrations:migrate --no-interaction --em=ReadWrite --configuration=app/config/migrations/read_write.yml
php app/console doctrine:migrations:migrate --no-interaction --em=Backend --configuration=app/config/migrations/backend.yml
php app/console doctrine:migrations:migrate --no-interaction --em=ServiceProvider --configuration=app/config/migrations/service_provider.yml
php app/console doctrine:migrations:migrate --no-interaction --em=Webservice --configuration=app/config/migrations/webservice.yml
```

### Assets

```shell script
php app/console assetic:dump
```

### Login

Visit http://your-domain.tld/admin

**Initial credentials and many more usefull information can be found in `install_report.json`. Don't forget to remove this file!** 

### Configure webserver Apache

```apacheconfig
<VirtualHost *:443>
    ServerName your-sso-uws.tld
    DocumentRoot "/absolute/path/to/installation/web"

    <Directory "/absolute/path/to/installation/web">
        Options Includes FollowSymLinks ExecCGI
        AllowOverride None
        <IfModule authz_host_module>
            Order allow,deny
            Allow from all
        </IfModule>
        FallbackResource /app.php
        DirectoryIndex app.php
    </Directory>

    <Directory /absolute/path/to/installation/web/bundles>
        FallbackResource disabled
    </Directory>
    <Directory /absolute/path/to/installation/web/css>
        FallbackResource disabled
    </Directory>
    <Directory /absolute/path/to/installation/web/js>
        FallbackResource disabled
    </Directory>

    SetEnv SYMFONY_ENV of
    SetEnv SYMFONY__ENABLE_APPLICATION_ACCESS_CONTROL true
    SetEnv DISABLE_SSO_LOGIN 1
</VirtualHost>
```

Parameters from `app/config/parameters.yml` can also be moved into the Apache configuration by using the `SYMFONY__` as shown above.

### Next steps

- install identity provider and connect to user webservice
- install wsp and connect to identity provider and user webservice
- install iam and connect to identity provider and user webservice
- install launchpad and connect to identity provider and user webservice

## AWS Instalation

This application is prepared for deployment into Elastic Beanstalk (EBS) of the Amazon Web Services (AWS).

### Requirements

- EBS instance micro with php support (PHP version 7.1)
- RDS instance with mysql support
- S3 storage to store configuration files
- EBS must have permissions for RDS and read permissions to S3

### Prepare RDS

It is highly recommended to prepare the databases with an initial set of records. The application comes with 2 different
sets of mysql dumps. If you prefer one database choose the dump in folder `mysql/join`, otherwise use the dumps in
`mysql/separate`.

- Create 2 databases (or one if user-data should not be separated administration-data): `uws-user` and `uws-admin`
- Update databases with dumps from mysql folder
- Create 1 or 2 user(s) and update user permissions with grant access to the database(s)

### Prepare EBS environment variables

Most of the environment variables will be set during deployment:

- **APP_LOGS** `/var/app/support/logs`
- **COMPOSER_HOME** `/root`
- **HOME** `/root`

The following variables must be set manually before the first deployment:

- **APP_CONFIG_URL** typical value `s3://my-s3-storage.tld/uws/playground/config`

### Prepare S3

The S3 storage is used to store the configuration files. The files are copied into the EBS instance during the
deployment process. Directory structure:

    aws
      |
      + config
         |
         + dev
         |  |
         |  + parameters.yml
         + prod
            |
            + parameters.yml

### Configuration files

#### aws/config/(dev|prod)/parameters.yml

The configuration files contain a number of parameters. Most of them should clearly be identified by its name.

The file beneath the `dev`-folder contains a configuration for debugging. This configuration is used, if you choose the
_Developer Edition_. The application will show the Symfony profiler, which give you a detailed view at the things
going on in your application. **The dev-configuration should not be used for production!**

The file in the `prod`-folder is pre-configured for production. Use this for your production environment but not
without updating some values! 

- **secret**:
should be changed for each application instance _[string]_

- **sso_tools_user_identifier.client_url**:
URL to the user-identifier-service, mostly the same as the URL of the
identity provider (idp) plus `/service/`, trailing slash is required _[url]_

- **tools_ciphering.mcrypt_additional_key**:
Encryption key used by the RESTful service between uws and idp. The
idp must use the same key otherwise the uws will not be able to decrypt messages from the idp, no login will be
possible _[string]_

- **database_\*_driver**:
Database driver, `pdo_mysql` should be the choice _[string]_

- **database_\*_host**:
Database host name, the rds endpoint, typically something like `project.qwerty.eu-west-1.rds.amazonaws.com` _[string]_

- **database_\*_port**:
Database port, mostly `3306` _[integer]_

- **database_\*_user**:
Database username, the above created user _[string]_

- **database_\*_password**:
Database password from the above created user _[string]_

- **database_\*_name**:
Database name, the name of the database in the rds, e. g. `uws-user` or `uws-admin` _[string]_

- **database_readwrite_name**:
Database name, the application can handle read-only databases, explanation will follow, use `uws-user` _[string]_

- **database_backend_name**:
Database name, for backend administration user data, typ. `uws-admin` _[string]_

- **database_sp_name**:
Database name, for service provider permission data, typ. `uws-admin` _[string]_

- **database_webservice_name**:
Database name, the main database, for user data, typ. `uws-user` _[string]_

### Deployment

1. Upload the zip file of your application to the EBS version management (EBS -> YourInstanceName (Dropdown in navigation)
-> Application Versions -> Upload). Select your version, click deploy and select your target instance.

2. The application comes with a set of predefined environment variables. Currently there is no need to change them.

3. Navigate to the url of the new application. You might see `Updating ...`.

4. Adjust the document root folder. Navigate to the instance' configuration and set the _Document root_ to `/web`.

5. Rise the _Memory limit_. The default value of `256M` might be not enough for a bigger amount of application data.
Adjust it to your needs. (optional)

6. Navigate to the url of the new application. You might see a xml
`<?xml version="1.0" encoding="UTF-8"?><SsoResponse><Status><![CDATA[Failure]]></Status>...</SsoResponse>`. This is normal.

7. Navigate to `/admin` and login with the default admin user (username: SuperAdmin#42#42, password: Cipher;Me;Now#9).
Don't forget to change the password! 

The application now has been deployed successfully. You should adjust the security tokens for webservice consumer
and for the idp.
