<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH
 * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

use Symfony\Component\HttpKernel\Kernel;
use Symfony\Component\Config\Loader\LoaderInterface;

/**
 * Class AppKernel
 */
class AppKernel extends Kernel
{

    /**
     * AppKernel constructor.
     * @param string $environment
     * @param bool $debug
     */
    public function __construct($environment, $debug) {
        date_default_timezone_set('Europe/Berlin');
        parent::__construct($environment, $debug);
    }

    public function registerBundles() {
        $bundles = array(
            new Symfony\Bundle\FrameworkBundle\FrameworkBundle(),
            new Symfony\Bundle\SecurityBundle\SecurityBundle(),
            new Symfony\Bundle\TwigBundle\TwigBundle(),
            new Symfony\Bundle\MonologBundle\MonologBundle(),
            new Symfony\Bundle\SwiftmailerBundle\SwiftmailerBundle(),
            new Symfony\Bundle\AsseticBundle\AsseticBundle(),
            new Doctrine\Bundle\DoctrineBundle\DoctrineBundle(),
            new Doctrine\Bundle\MigrationsBundle\DoctrineMigrationsBundle(),
            new Sensio\Bundle\FrameworkExtraBundle\SensioFrameworkExtraBundle(),
            new JMS\SerializerBundle\JMSSerializerBundle(),
            new LifeStyle\Tools\DbLogBundle\LifeStyleToolsDbLogBundle(), // Must be before SsoWebserviceBundle
            new Sso\WebserviceBundle\SsoWebserviceBundle(),
            new Sso\BackendBundle\SsoBackendBundle(),
            new Sso\BackendSecurityBundle\SsoBackendSecurityBundle(),
            new Sso\BackendSessionBundle\SsoBackendSessionBundle(),
            new Sso\HelpBundle\SsoHelpBundle(),
            new Sso\DemoBundle\SsoDemoBundle(),
            new FOS\UserBundle\FOSUserBundle(),
            new Lexik\Bundle\FormFilterBundle\LexikFormFilterBundle(),
            new LifeStyle\Tools\XmlBundle\LifeStyleToolsXmlBundle(),
            new LifeStyle\Tools\ORMHelperBundle\LifeStyleToolsORMHelperBundle(),
            new Sso\Tools\AWSBundle\SsoToolsAWSBundle(),
            new Sso\Tools\UserIdentifierBundle\SsoToolsUserIdentifierBundle(),
            new Knp\Bundle\PaginatorBundle\KnpPaginatorBundle(),
            // lifeStyle Tools
            new LifeStyle\Tools\RestAuthBundle\LifeStyleToolsRestAuthBundle(),
            new LifeStyle\Tools\RestErrorBundle\LifeStyleToolsRestErrorBundle(),
            new Sso\RestBundle\SsoRestBundle(),
            // security extra bundles
            new JMS\AopBundle\JMSAopBundle(),
            new JMS\SecurityExtraBundle\JMSSecurityExtraBundle(),
            new JMS\DiExtraBundle\JMSDiExtraBundle(),
            // rest stuff
            new FOS\RestBundle\FOSRestBundle(),
            new Nelmio\ApiDocBundle\NelmioApiDocBundle(),
            new LifeStyle\Tools\CipheringBundle\LifeStyleToolsCipheringBundle(),
            // MFA
            new Endroid\QrCode\Bundle\EndroidQrCodeBundle(),
            new LifeStyle\Tools\MfaBundle\LifeStyleToolsMfaBundle(),
            new Sso\AccessBundle\SsoAccessBundle(),
            // SAML
            new LifeStyle\SamlAuthBundle\LifeStyleSamlAuthBundle(),
            new LifeStyle\ActivityLogBundle\LifeStyleActivityLogBundle(),
            new LifeStyle\TemplateBundle\LifeStyleTemplateBundle(),
            // Specific
            new LifeStyle\DH\AccessControlBundle\AccessControlBundle(),
            new LifeStyle\DH\AttributeGeneratorBundle\AttributeGeneratorBundle(),
        );

        if (in_array($this->getEnvironment(), array('dev', 'aws_dev', 'test', 'of', 'sb', 'mh', 'staging', 'lsd'))) {
            $bundles[] = new Symfony\Bundle\DebugBundle\DebugBundle();
            $bundles[] = new Webfactory\Bundle\ExceptionsBundle\WebfactoryExceptionsBundle();
            $bundles[] = new Symfony\Bundle\WebProfilerBundle\WebProfilerBundle();
            $bundles[] = new Sensio\Bundle\DistributionBundle\SensioDistributionBundle();
            $bundles[] = new Sensio\Bundle\GeneratorBundle\SensioGeneratorBundle();
        }

        if (in_array($this->getEnvironment(), array('test'))) {
            $bundles[] = new Sso\Tools\UserIdentifierTestBundle\SsoToolsUserIdentifierTestBundle();
            $bundles[] = new Doctrine\Bundle\FixturesBundle\DoctrineFixturesBundle();
            $bundles[] = new Liip\FunctionalTestBundle\LiipFunctionalTestBundle();
        }

        return $bundles;
    }

    /**
     * @param LoaderInterface $loader
     * @throws Exception
     */
    public function registerContainerConfiguration(LoaderInterface $loader)
    {
        $loader->load(__DIR__ . '/config/config_' . $this->getEnvironment() . '.yml');
    }

    /**
     * @return string
     */
    public function getRootDir()
    {
        return __DIR__;
    }

    /**
     * @return string
     */
    public function getCacheDir()
    {
        return dirname(__DIR__).'/var/cache/'.$this->getEnvironment();
    }

    /**
     * @return string
     */
    public function getLogDir()
    {
        $logDir = getenv('APP_LOGS');
        return false !== $logDir && is_dir($logDir) ? $logDir : dirname(__DIR__).'/var/logs';
    }
}
