<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Application\Migrations;

use Doctrine\DBAL\Migrations\AbortMigrationException;
use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Class Version20190916065945
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Application\Migrations
 */
class Version20190916065945 extends AbstractMigration
{
    private $message = 'Warning: Doctrine migrations cannot be run without options because this application uses multiple database connections.' . PHP_EOL .
    'Try this: ' . PHP_EOL .
    '    php app/console doctrine:migrations:migrate --em=Webservice --configuration=app/config/migrations/webservice.yml' . PHP_EOL .
    'or' . PHP_EOL .
    '    php app/console doctrine:migrations:migrate --em=ReadWrite --configuration=app/config/migrations/read_write.yml' . PHP_EOL .
    'or' . PHP_EOL .
    '    php app/console doctrine:migrations:migrate --em=Backend --configuration=app/config/migrations/backend.yml' . PHP_EOL .
    'or' . PHP_EOL .
    '    php app/console doctrine:migrations:migrate --em=ServiceProvider --configuration=app/config/migrations/service_provider.yml' . PHP_EOL;

    /**
     * @param Schema $schema
     * @throws AbortMigrationException
     */
    public function up(Schema $schema)
    {
        $this->abortIf(true, $this->message);
    }

    /**
     * @param Schema $schema
     * @throws AbortMigrationException
     */
    public function down(Schema $schema)
    {
        $this->abortIf(true, $this->message);
    }
}
