#!/usr/bin/env bash
set -e

#################################################################
#
# This script should only be executed within the leader instance!
#
#################################################################

. /opt/elasticbeanstalk/support/envvars

cd $(cd $(dirname $0); echo $PWD)
test -x envvars.sh && . envvars.sh
test -x envvars_dev.sh && . envvars_dev.sh
cd ..
set -xe

if [ "$APP_INSTALL" == "true" ]; then

    echo "Application create database start..."

    #
    # Create databases before application is deployed
    #
    php app/console doctrine:database:create --no-interaction --connection=ReadWrite
    php app/console doctrine:database:create --no-interaction --connection=Backend
    php app/console doctrine:database:create --no-interaction --connection=ServiceProvider
    php app/console doctrine:database:create --no-interaction --connection=Webservice

    echo "Application create database done."

else
    echo "If you want to create the databases, go to configuration - software configuration - environment variables and set APP_INSTALL to true."
fi
