#!/usr/bin/env bash
set -e
. /opt/elasticbeanstalk/support/envvars

cd $(cd $(dirname $0); echo $PWD)
test -x envvars.sh && . envvars.sh
test -x envvars_dev.sh && . envvars_dev.sh
cd ..
set -xe

echo "Update .htaccess for webservice."
rm -f web/.htaccess
cat >> web/.htaccess <<END_OF_TEXT
DirectoryIndex index.php
<IfModule mod_negotiation.c>
    Options -MultiViews
</IfModule>
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteCond %{HTTP_USER_AGENT} !^ELB-HealthChecker
    RewriteCond %{HTTP:X-Forwarded-Proto} !https
    RewriteRule !/status https://%{SERVER_NAME}%{REQUEST_URI} [L,R]
    RewriteCond %{REQUEST_URI}::$1 ^(/.+)/(.*)::\2$
    RewriteRule ^(.*) - [E=BASE:%1]
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]
    RewriteCond %{ENV:REDIRECT_STATUS} ^$
    RewriteRule ^index\.php(/(.*)|$) %{ENV:BASE}/$2 [R=301,L]
    RewriteCond %{REQUEST_FILENAME} -f
    RewriteRule .? - [L]
    RewriteRule .? %{ENV:BASE}/index.php [L]
</IfModule>
<IfModule !mod_rewrite.c>
    <IfModule mod_alias.c>
        RedirectMatch 302 ^/$ /index.php/
    </IfModule>
</IfModule>

END_OF_TEXT
