<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\ActivityLogBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * Class LifeStyleActivityLogExtension
 * @package LifeStyle\ActivityLogBundle\DependencyInjection
 */
class LifeStyleActivityLogExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yml');

        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        if (isset($config['textfilters'])) {
            $this->configureTextFilter($config['textfilters'], $container);
        }
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureTextFilter(array $config, ContainerBuilder $container)
    {
        if (!$container->hasDefinition('life_style_activity_log.filter.text_filter_configuration')) {
            return;
        }

        $definition = $container->getDefinition('life_style_activity_log.filter.text_filter_configuration');

        foreach ($config as $textFilter) {
            $definition->addMethodCall('addFilter', [ $textFilter['search'], $textFilter['replace'] ]);
        }
    }
}
