<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * Class LifeStyleSamlAuthExtension
 * @package LifeStyle\SamlAuthBundle\DependencyInjection
 */
class LifeStyleSamlAuthExtension extends Extension
{
    /**
     * @return string
     */
    public function getAlias()
    {
        return 'life_style_saml_auth';
    }

    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        // load service definitions
        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yml');

        // process configuration fragments
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        //set values
        $serviceDefinition = $container->getDefinition('saml.saml_config');
        $serviceDefinition->addMethodCall('setSpName', [$config['sp_name']]);
        $serviceDefinition->addMethodCall('setIdpAppName', [$config['idp_app_name']]);
    }
}
