<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use LifeStyle\ActivityLogBundle\Entity\UserActionLog;

/**
 * Class User
 * @package LifeStyle\SamlAuthBundle\Entity
 *
 * @ORM\Table(name="saml_user")
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks()
 */
class User
{
    /**
     * @ORM\Column(type="guid", name="id")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="UUID")
     * @var string
     */
    private $keyId;

    /**
     * @ORM\Column(name="user_guid", type="string", length=255, nullable=false)
     * @var string
     */
    private $userGuid;

    /**
     * @ORM\Column(name="user_email", type="string", length=255, nullable=true)
     * @var string
     */
    private $userEmail;

    /**
     * @ORM\Column(name="user_name", type="string", length=255, nullable=true)
     * @var string
     */
    private $userName;

    /**
     * @ORM\Column(name="first_name", type="string", length=255, nullable=true)
     * @var string
     */
    private $firstName;

    /**
     * @ORM\Column(name="last_name", type="string", length=255, nullable=true)
     * @var string
     */
    private $lastName;

    /**
     * @ORM\Column(name="created_at", type="datetime", nullable=false)
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @ORM\Column(name="updated_at", type="datetime", nullable=false)
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @ORM\OneToMany(targetEntity="UserLoginHistory", mappedBy="user", cascade={"persist"})
     * @var UserLoginHistory[]
     */
    private $userLoginHistory;

    /**
     * @ORM\OneToMany(targetEntity="LifeStyle\ActivityLogBundle\Entity\UserActionLog", mappedBy="user", cascade={"persist"})
     * @var UserActionLog[]
     */
    private $userActionLog;

    /**
     * User constructor.
     */
    public function __construct()
    {
        $this->userLoginHistory = new ArrayCollection();
        $this->userActionLog = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->keyId;
    }

    /**
     * @param string $keyId
     * @return User
     */
    public function setId($keyId)
    {
        $this->keyId = $keyId;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getUserEmail()
    {
        return $this->userEmail;
    }

    /**
     * @param mixed $userEmail
     * @return User
     */
    public function setUserEmail($userEmail)
    {
        $this->userEmail = $userEmail;

        return $this;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @param string $firstName
     * @return User
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;

        return $this;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @param string $lastName
     * @return User
     */
    public function setLastName($lastName)
    {
        $this->lastName = $lastName;

        return $this;
    }

    /**
     * @return UserLoginHistory[]
     */
    public function getUserLoginHistory()
    {
        return $this->userLoginHistory;
    }

    /**
     * @param UserLoginHistory $userLoginHistory
     * @return User
     */
    public function addUserLoginHistory(UserLoginHistory $userLoginHistory)
    {
        if (!$this->userLoginHistory->contains($userLoginHistory)) {
            $this->userLoginHistory->add($userLoginHistory);
        }

        return $this;
    }

    /**
     * @ORM\PrePersist
     */
    public function setCreatedAt()
    {
        $this->createdAt = new \DateTime();
        $this->updatedAt = new \DateTime();
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @ORM\PreUpdate
     */
    public function setUpdatedAt()
    {
        $this->updatedAt = new \DateTime();
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @return string
     */
    public function getUserGuid()
    {
        return $this->userGuid;
    }

    /**
     * @param string $userGuid
     * @return User
     */
    public function setUserGuid($userGuid)
    {
        $this->userGuid = $userGuid;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param string $userName
     * @return User
     */
    public function setUserName($userName)
    {
        $this->userName = $userName;

        return $this;
    }

    /**
     * @return UserActionLog[]
     */
    public function getUserActionLog()
    {
        return $this->userActionLog;
    }

    /**
     * @param UserActionLog $userActionLog
     * @return User
     */
    public function addUserActionLog(UserActionLog $userActionLog)
    {
        if (!$this->userActionLog->contains($userActionLog)) {
            $this->userActionLog->add($userActionLog);
        }

        return $this;
    }
}
