<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Security\Authentication\Token;

use Symfony\Component\Security\Core\Authentication\Token\AbstractToken;
use LifeStyle\SamlAuthBundle\Model\UserApplication\Application as UserApplication;
use LifeStyle\SamlAuthBundle\Model\UserData\User as UserDto;

/**
 * Class SamlToken
 * @package LifeStyle\SamlAuthBundle\Security\Authentication\Token
 */
class SamlToken extends AbstractToken
{
    /**
     * @var string
     */
    public $userName;

    /**
     * @var string
     */
    public $userId;

    /**
     * @var string
     */
    public $email;

    /**
     * @var string
     */
    public $firstname;

    /**
     * @var string
     */
    public $lastname;

    /**
     * @var UserApplication
     */
    public $appData;

    /**
     * @var UserDto
     */
    public $userData;

    /**
     * SamlToken constructor.
     * @param array $roles
     */
    public function __construct(array $roles = array())
    {
        parent::__construct($roles);

        // If the user has roles, consider it authenticated
        $this->setAuthenticated(count($roles) > 0);
    }

    /**
     * @return string
     */
    public function getCredentials()
    {
        return '';
    }

    /**
     * @return UserDto
     */
    public function getUserDto()
    {
        return $this->userData;
    }
}
