<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Tests\Database\Data;

use Liip\FunctionalTestBundle\Test\WebTestCase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use LifeStyle\SamlAuthBundle\Database\Manager as DatabaseManager;
use LifeStyle\SamlAuthBundle\Database;

/**
 * Class FactoryTest
 * @package LifeStyle\SamlAuthBundle\Tests\Database\Data
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var ContainerInterface
     */
    protected $container;

    /**
     * @var DoctrineRegistry
     */
    private $doctrineRegistry;

    public function setUp()
    {
        parent::setUp();
        $client = static::createClient();
        $this->container = $client->getContainer();
        $this->doctrineRegistry = $this->container->get('doctrine');
    }

    public function testInstances()
    {
        $dbM = new DatabaseManager($this->doctrineRegistry);
        $this->assertInstanceOf(Database\Data\UserLoginHistory\Index::class, $dbM->data()->userLoginHistory());
        $this->assertInstanceOf(Database\Data\User\Index::class, $dbM->data()->user());
    }
}
