<?php

namespace LifeStyle\SamlAuthBundle\Tests\Database\Entity;

use Liip\FunctionalTestBundle\Test\WebTestCase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use LifeStyle\SamlAuthBundle\Database\Manager as DatabaseManager;
use LifeStyle\SamlAuthBundle\Entity;

/**
 * Class ManagerTest
 * @package LifeStyle\SamlAuthBundle\Tests\Database\Entity
 */
class ManagerTest extends WebTestCase
{
    /**
     * @var ContainerInterface
     */
    protected $container;

    /**
     * @var DoctrineRegistry
     */
    private $doctrineRegistry;

    public function setUp()
    {
        parent::setUp();
        $client = static::createClient();
        $this->container = $client->getContainer();
        $this->doctrineRegistry = $this->container->get('doctrine');
    }

    public function testInstances()
    {
        $dbM = new DatabaseManager($this->doctrineRegistry);
        $this->assertInstanceOf(Entity\UserLoginHistory::class, $dbM->entity()->userLoginHistory());
        $this->assertInstanceOf(Entity\User::class, $dbM->entity()->user());
    }
}
