<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Services;

use SimpleSAML\Error\CriticalConfigurationError;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use LifeStyle\SamlAuthBundle\Configuration\SamlConfig;
use Psr\Log\LoggerInterface;
use SimpleSAML\Auth\Simple as SimpleSamlAuthSimple;

/**
 * Class SamlServiceTest
 * @package LifeStyle\SamlAuthBundle\Services
 */
class SamlServiceTest extends WebTestCase
{
    public function testServiceInstantiation()
    {
        $config = new SamlConfig();
        $config->setSpName('spName');

        try{
            $serviceObject = new SamlService($config);
            $saml = $serviceObject->getSimpleSaml();
        }catch (CriticalConfigurationError $exception){
            $this->assertInstanceOf(CriticalConfigurationError::class, $exception);
        }



    }
}
