<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\TemplateBundle\Model;

/**
 * Class ImageAssets
 * @package LifeStyle\TemplateBundle\Model
 */
class ImageAssets
{
    /**
     * @var string
     */
    private $logoPathSmall = '';

    /**
     * @var string
     */
    private $logoPathBig = '';

    /**
     * @var string
     */
    private $faviconPath = 'favicon.ico';

    /**
     * @var array
     */
    private $mapperArray = [
        'logo_path_small' => 'logoPathSmall',
        'logo_path_big' => 'logoPathBig',
        'favicon' => 'faviconPath',
    ];

    /**
     * ColorAssets constructor.
     * @param array $configArray
     */
    public function __construct(array $configArray)
    {
        foreach ($this->mapperArray as $item => $value){
            $this->{$value} = $configArray[$item];
        }
    }

    /**
     * @return string
     */
    public function getLogoPathSmall(): string
    {
        return $this->logoPathSmall;
    }

    /**
     * @return string
     */
    public function getLogoPathBig(): string
    {
        return $this->logoPathBig;
    }

    /**
     * @return string
     */
    public function getFaviconPath(): string
    {
        return $this->faviconPath;
    }
}
