<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CipheringBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 * @package LifeStyle\Tools\CipheringBundle\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('life_style_tools_ciphering');
        $rootNode->children()
            ->variableNode('mcrypt_cypher_name')
            ->defaultValue("MCRYPT_RIJNDAEL_256")
            ->end();
        $rootNode->children()
            ->variableNode('openssl_is_fallback')
            ->defaultValue(false)
            ->end();
        $rootNode->children()
            ->arrayNode('openssl_cypher_names')
                ->isRequired()
                ->requiresAtLeastOneElement()
                ->performNoDeepMerging()
                ->prototype('scalar')
                ->defaultValue(['AES-256-CBC'])
                ->end()
            ->end();
        $rootNode->children()
            ->variableNode('mcrypt_mode_name')
            ->defaultValue("MCRYPT_MODE_CBC")
            ->end();
        $rootNode->children()
            ->variableNode('mcrypt_additional_key')
            ->defaultValue("thisisnotsecretchangeit")
            ->end();

        return $treeBuilder;
    }
}
