<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\DbLogBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;

/**
 * Class SystemLog
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Tools\DbLogBundle\Entity
 *
 * @ORM\Entity(repositoryClass="LifeStyle\Tools\DbLogBundle\Entity\SystemLogRepository")
 * @ORM\Table(
 *     name="system_log",
 *     indexes={
 *         @ORM\Index(name="idx_level", columns={"level","createdTime","created","modified","extras","channel","username"}),
 *         @ORM\Index(name="idx_channel", columns={"channel","createdTime","created","modified","extras","level","username"}),
 *         @ORM\Index(name="idx_extras", columns={"extras","createdTime","created","modified","channel","level","username"}),
 *         @ORM\Index(name="idx_createdTime", columns={"createdTime","created","modified","extras","channel","level","username"}),
 *         @ORM\Index(name="idx_username", columns={"username","createdTime","created","modified","extras","channel","level"})
 *     }
 * )
 */
class SystemLog
{

    /**
     * @ORM\Id
     * @ORM\Column(type="string", nullable=false, length=64)
     * @ORM\GeneratedValue(strategy="NONE")
     * @var string
     */
    private $id;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @var integer
     */
    private $level;

    /**
     * @ORM\Column(type="string", length=32, nullable=true)
     * @var string
     */
    private $channel;

    /**
     * @ORM\Column(type="string", length=32, nullable=true)
     * @var string
     */
    private $extras;

    /**
     * @ORM\Column(type="string", length=32, nullable=true)
     * @var string
     */
    private $username;

    /**
     * @ORM\Column(type="datetime")
     * @var \DateTime
     */
    private $modified;

    /**
     * @ORM\Column(type="datetime")
     * @var \DateTime
     */
    private $created;

    /**
     * @ORM\Column(type="bigint", options={"unsigned"=true})
     * @var integer
     */
    private $createdTime;

    /**
     * @ORM\OneToOne(targetEntity="SystemLogData", mappedBy="systemLog")
     * @var SystemLogData
     */
    private $systemLogData;

    /**
     * Generate id on construct
     */
    public function __construct()
    {
        $this->id = Uuid::uuid4()->toString();
        $this->created = new \DateTime();
        $this->createdTime = microtime(true) * 10;
        $this->modified = new \DateTime();
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return int
     */
    public function getLevel()
    {
        return $this->level;
    }

    /**
     * @param int $level
     */
    public function setLevel($level)
    {
        $this->level = $level;
    }

    /**
     * @return string
     */
    public function getChannel()
    {
        return $this->channel;
    }

    /**
     * @param string $channel
     */
    public function setChannel($channel)
    {
        $this->channel = $channel;
    }

    /**
     * @return string
     */
    public function getExtras()
    {
        return $this->extras;
    }

    /**
     * @param string $extras
     */
    public function setExtras($extras)
    {
        $this->extras = $extras;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     */
    public function setUsername($username)
    {
        $this->username = $username;
    }

    /**
     * @return \DateTime
     */
    public function getModified()
    {
        return $this->modified;
    }

    /**
     * @param \DateTime $modified
     */
    public function setModified(\DateTime $modified)
    {
        $this->modified = $modified;
    }

    /**
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @return int
     */
    public function getCreatedTime()
    {
        return $this->createdTime;
    }

    /**
     * @return SystemLogData
     */
    public function getSystemLogData()
    {
        return $this->systemLogData;
    }

    /**
     * @param SystemLogData $systemLogData
     */
    public function setSystemLogData($systemLogData)
    {
        $systemLogData->setSystemLog($this);
        $this->systemLogData = $systemLogData;
    }
}
