<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\DbLogBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class SystemLogData
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Tools\DbLogBundle\Entity
 *
 * @ORM\Entity(repositoryClass="LifeStyle\Tools\DbLogBundle\Entity\SystemLogRepository")
 * @ORM\Table(name="system_log_data")
 */
class SystemLogData
{

    /**
     * @ORM\Id
     * @ORM\Column(type="string", nullable=false, length=64)
     * @ORM\GeneratedValue(strategy="NONE")
     * @var string
     */
    private $id;

    /**
     * @ORM\OneToOne(targetEntity="SystemLog", inversedBy="systemLogData")
     * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
     * @var SystemLog
     */
    private $systemLog;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @var string
     */
    private $log;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @var string
     */
    private $serverData;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return SystemLog
     */
    public function getSystemLog()
    {
        return $this->systemLog;
    }

    /**
     * @param SystemLog $systemLog
     */
    public function setSystemLog(SystemLog $systemLog)
    {
        $this->systemLog = $systemLog;
        $this->id = $systemLog->getId();
    }

    /**
     * @return string
     */
    public function getLog()
    {
        return $this->log;
    }

    /**
     * @param string $log
     */
    public function setLog($log)
    {
        $this->log = $log;
    }

    /**
     * @return string
     */
    public function getServerData()
    {
        return $this->serverData;
    }

    /**
     * @param string $serverData
     */
    public function setServerData($serverData)
    {
        $this->serverData = $serverData;
    }
}
