<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\DbLogBundle\Processor;

use LifeStyle\Tools\DbLogBundle\ProcessDetailsInterface;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Bridge\Monolog\Processor\WebProcessor;
use Monolog\Formatter\FormatterInterface;

/**
 * Class RequestProcessor
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Tools\DbLogBundle\Processor
 */
class RequestProcessor extends WebProcessor implements FormatterInterface
{
    /**
     * @var Session
     */
    private $session;

    /**
     * @var ProcessDetailsInterface
     */
    private $processDetails;

    /**
     * RequestProcessor constructor.
     * @param Session $session
     * @param ProcessDetailsInterface $processDetails
     */
    public function __construct(Session $session, ProcessDetailsInterface $processDetails)
    {
        parent::__construct();
        $this->session = $session;
        $this->processDetails = $processDetails;
    }

    /**
     * @param array $record
     * @return array
     */
    public function processRecord(array $record)
    {
        $record['extra']['username'] = $this->processDetails->getUsername();
        $record['extra']['serverData'] = "";

        if (is_array($this->serverData)) {
            foreach ($this->serverData as $key => $value) {

                if (is_array($value)) {
                    $value = print_r($value, true);
                }

                $record['extra']['serverData'] .= $key . ": " . $value . "\n";
            }
        }

        foreach ($_SERVER as $key => $value) {

            if (is_array($value)) {
                $value = print_r($value, true);
            }
            $record['extra']['serverData'] .= $key . ": " . $value . "\n";
        }

        return $record;
    }

    /**
     * @param array $record
     * @return mixed|void
     */
    public function format(array $record)
    {

    }

    /**
     * @param array $records
     * @return mixed|void
     */
    public function formatBatch(array $records)
    {

    }
}
