<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\MfaBundle\Api;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;

/**
 * Class Manager
 * @package LifeStyle\Tools\MfaBundle\Api
 */
class Manager
{
    /**
     * @var Container
     */
    public $container;

    /**
     * @var array
     */
    protected $factory;

    /**
     * Manager constructor.
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * @return Mfa\Factory
     */
    public function mfa()
    {
        if (!isset($this->factory['mfa'])) {
            $this->factory['mfa'] = new Mfa\Factory($this);
        }

        return $this->factory['mfa'];
    }

    /**
     * @return Container
     */
    public function getContainer()
    {
        return $this->container;
    }
}
