<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\MfaBundle\Api\Mfa\Image;

use Endroid\QrCode\QrCode;
use LifeStyle\Tools\MfaBundle\Api\Mfa\OtpAuth\Index as OtpAuth;

/**
 * Class Index
 * @package LifeStyle\Tools\MfaBundle\Api\Mfa\Image
 */
class Index
{
    /**
     * @var OtpAuth
     */
    protected $otpAuth;

    /**
     * Index constructor.
     * @param OtpAuth $otpAuth
     */
    public function __construct(OtpAuth $otpAuth)
    {
        $this->otpAuth = $otpAuth;
    }

    /**
     * @param string $username
     * @param string $secret
     * @param int $size
     * @return string
     */
    public function generateQr($username, $secret, $size = 200)
    {
        $qrCode = new QrCode();
        $qrCode->setText($this->otpAuth->getUri($username, $secret));

        if ($size !== null) {
            $qrCode->setSize($size);
        }

        return $qrCode->getDataUri();
    }
}
