<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\MfaBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use JMS\SecurityExtraBundle\Annotation\Secure;

/**
 * Class TestController
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Tools\MfaBundle\Controller
 */
class TestController extends Controller
{
    /**
     * @Secure(roles="ROLE_SUPER_ADMIN")
     * @param Request $request
     * @Route("/qr/generate", name="life_style_tools_mfa_qr_generate")
     * @Template()
     *
     * @return array
     */
    public function qrGenerateAction(Request $request)
    {
        $form = $this->createFormBuilder()
            ->add('username', 'text')
            ->add('secret', 'text')
            ->add('generate code', 'submit')
            ->getForm();

        $form->handleRequest($request);

        $qrMessage = "";

        if ($form->isValid()) {

            $formArray = $form->getData();
            $username = $formArray['username'];
            $secret = $formArray['secret'];
            $qrMessage = 'otpauth://totp/' . $username . '?secret=' . $secret . '&issuer=sso-sso';
        }

        return ['form' => $form->createView(), 'qrMessage' => $qrMessage];
    }
}
