<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle\Api\Configuration;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;

/**
 * Class Index
 * @package LifeStyle\Tools\RestAuthBundle\Api\Configuration
 */
class Index
{
    /**
     * Symfony container
     * @var Container
     */
    private $container;

    /**
     * Constructor
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }
    
    /**
     * @return integer
     */
    public function getWsseLifetime(){
        return $this->container->getParameter('life_style_tools_rest_auth')['wsse_lifetime'];
    }

    /**
     * @return boolean
     */
    public function getSecuredAgainstReplayAttack(){
        return $this->container->getParameter('life_style_tools_rest_auth')['secured_against_replay_attack'];
    }
}
