<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle\Api;

use Psr\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use Symfony\Component\HttpFoundation\Session\Session;

/**
 * Class Manager
 * @package LifeStyle\Tools\RestAuthBundle\Api
 */
class Manager
{
    /**
     * @var Container
     */
    private $container;

    /**
     * @var array
     */
    private $factory = array();

    /**
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * @return LoggerInterface
     */
    public function logger()
    {
        return $this->container->get('logger');
    }

    /**
     * @return Session
     */
    public function session()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Session());
    }

    /**
     * @return object
     */
    public function client()
    {
        return $this->container->get('guzzle.client');
    }

    /**
     * @return \JMS\Serializer\Serializer
     */
    public function serializer()
    {
        return $this->container->get('jms_serializer');
    }

    /**
     * @return Controller
     */
    public function controller()
    {
        return new Controller($this);
    }

    /**
     * @return Container
     */
    public function getContainer()
    {
        return $this->container;
    }

    /**
     * @return Configuration\Index
     */
    public function configuration()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Configuration\Index($this->container));
    }

    /**
     * @return Database\Index
     */
    public function database()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Database\Index($this));
    }
}
