<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle;

use Symfony\Component\HttpKernel\Bundle\Bundle;
use LifeStyle\Tools\RestAuthBundle\DependencyInjection\Security\Factory\UidentifyFactory;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class LifeStyleToolsRestAuthBundle
 * @package LifeStyle\Tools\RestAuthBundle
 */
class LifeStyleToolsRestAuthBundle extends Bundle
{
    /**
     * @param ContainerBuilder $container
     */
    public function build(ContainerBuilder $container)
    {
        parent::build($container);

        $extension = $container->getExtension('security');
        $extension->addSecurityListenerFactory(new UidentifyFactory());
    }
}
