<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestErrorBundle\Api\Error\Errors;

use Symfony\Bridge\Monolog\Logger;

/**
 * Class Index
 * @package LifeStyle\Tools\RestErrorBundle\Api\Error\Errors
 */
class Index
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var Entity\Errors
     */
    protected $errors;

    /**
     * @var Entity\Errors
     */
    protected $error;

    /**
     * @var integer
     */
    protected $status;
    
    /**
     * @var Logger
     */
    protected $log;

   /**
    * @param Logger $log
    */
    public function __construct(Logger $log)
    {
        $this->log = $log;
        $this->errors = $this->getErrorsEntity();
        $this->setStatus(200);
    }

    /**
     * @param integer $code
     * @param string $message
     * @param string $type
     * @param string $exception
     * @param string $debug
     * @return Index
     */
    public function addError($code, $message, $type, $exception = 'not set', $debug = 'not set')
    {
        $error = $this->getErrorEntity();
        $error->setCode($code);
        $error->setMessage($message);
        $error->setType($type);
        $error->setException($exception);
        $error->setDebug($debug);
        
        $this->errors->addError($error);
        return $this;
    }

    /**
     * @return Entity\Errors
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @return boolean
     */
    public function hasErrors()
    {
        return $this->errors->hasErrors();
    }

    /**
     * @return integer
     */
    public function getErrorsCount()
    {
        return $this->errors->getErrorsCount();
    }

    /**
     * @param integer $status
     */
    public function setStatus($status)
    {
        $this->errors->setStatus($status);
    }

    /**
     * @return integer
     */
    public function getStatus()
    {
        return $this->errors->getStatus();
    }
    
    /**
     * @param string $trackId
     */
    public function setTrackId($trackId)
    {
        $this->errors->setTrackId($trackId);
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->errors->getTrackId();
    }

    /**
     * @return Entity\Errors
     */
    private function getErrorsEntity()
    {
        if (!isset($this->facSetter['ErrorsEntity'])) {
            $this->facSetter['ErrorsEntity'] = new Entity\Errors();
        }
        return $this->facSetter['ErrorsEntity'];
    }
    
    /**
     * always a new instance!
     * 
     * @return Entity\Error
     */
    private function getErrorEntity(){
        
        return new Entity\Error();
    }
}
