<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestErrorBundle\Tests\Api\Errors;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use LifeStyle\Tools\RestErrorBundle\Api;
use Symfony\Component\Security\Core\Exception\AuthenticationException;

/**
 * Class IndexTest
 * @package LifeStyle\Tools\RestErrorBundle\Tests\Api\Errors
 */
class IndexTest extends WebTestCase
{
    /**
     * @var Api\Manager
     */
    public $errorApiM;

    /**
     * @var Client
     */
    protected $client;

    /**
     * @var ContainerInterface
     */
    protected $container;

    protected function setUp()
    {
        $this->client = static::createClient();
        $this->container = $this->client->getContainer();
        $this->errorApiM = new Api\Manager($this->container);
    }

    public function testTrueGenerateSeoUrls()
    {
        $this->errorApiM->error()->errors()->setStatus(200);
        $this->errorApiM->error()->errors()->addError(10, 'message', 'internal', 'exception', 'debug');
        
        $errors = $this->errorApiM->error()->errors();
        $this->assertTrue($errors->hasErrors() == true);
        $this->assertTrue($errors->getStatus() == 200);
        $this->assertTrue($errors->getErrors()->getMessage() == 'OK');
        $this->assertTrue($errors->getErrors()->getErrorsCount() == 1);
        
        $errors->getErrors()->setStatus(300);
        $this->assertTrue($errors->getErrors()->getStatus() == 300);

        foreach ($errors->getErrors()->getError() as $error) {
            $this->assertTrue($error->getCode() == 10);
            $this->assertTrue($error->getMessage() == 'message');
            $this->assertTrue($error->getType() == 'internal');
            $this->assertTrue($error->getDebug() == 'debug');
            $this->assertTrue($error->getException() == 'exception');
        }
        
        //now remove
        foreach ($errors->getErrors()->getError() as $error) {
            $errors->getErrors()->removeError($error);
        }
        //$this->assertTrue(empty($errors->getErrors()->getError()));
        $this->assertTrue($errors->getErrors()->getErrorsCount() == 0);
        $this->assertTrue($this->errorApiM->error()->errors()->getErrorsCount() == 0);
        
        
    }
}
