<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace DoctrineMigrations;

/**
 * Trait InstallTrait
 * @package Migrations
 */
trait InstallTrait
{
    /**
     * @param array $value
     */
    private function addInstallDocsAttribute(array $value): void
    {
        file_put_contents(
            $this->getInstallDocsFilename(),
            json_encode(array_merge($this->getInstallDocsAttributes(), $value), JSON_PRETTY_PRINT)
        );
    }

    /**
     * @return array
     */
    private function getInstallDocsAttributes(): array
    {
        if (
            file_exists($filename = $this->getInstallDocsFilename()) &&
            false !== ($file = file_get_contents($filename)) &&
            is_array($content = json_decode($file, true))
        ) {
            return $content;
        }

        return [];
    }

    /**
     * @return string
     */
    private function getInstallDocsFilename(): string
    {
        return dirname(dirname(__DIR__)) . '/install_report.json';
    }
}
