<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class ServiceController
 * @package Sso\BackendBundle\Controller
 */
class ServiceController extends Controller
{

    /**
     * Database manager name
     * @var string
     */
    protected $dbS = 'service_database_manager';

    /**
     * @Route("/", name="_admin_backend_service_list")
     * @Template()
     * @return Response
     */
    public function listAction()
    {
        return ['services' => $this->databaseManager()->serviceProvider()->service()->getAll()];
    }

    /**
     * @Route("/", name="_admin_backend_service")
     * @Template()
     * @return Response
     */
    public function indexAction()
    {
        return ['entities' => $this->databaseManager()->serviceProvider()->service()->getAll()];
    }

    /**
     * @Route("/", name="_admin_backend_service_add")
     * @Template()
     * @return Response
     */
    public function addAction()
    {
        return [];
    }

    /**
     * @Route("/", name="_admin_backend_service_delete")
     * @Template()
     * @return Response
     */
    public function deleteAction()
    {
        return [];
    }

    /**
     * @Route("/", name="_admin_backend_service_show")
     * @Template()
     * @return Response
     */
    public function showAction()
    {
        return [];
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Manager
     */
    protected function databaseManager()
    {
        return $this->get($this->dbS);
    }
}
