<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Sso\BackendBundle\Model\Form\PasswordPolicyTranslations;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;

/**
 * Class PasswordPoliciesType
 * @package Sso\BackendBundle\Form
 */
class PasswordPoliciesTranslationsType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'language',
                ChoiceType::class,
                array(
                    'choices' => array(
                        '' => '',
                        'default' => 'default',
                        'fr' => 'fr',
                        'en' => 'en',
                        'de' => 'de',
                        'ja' => 'ja'
                    ),
                    'attr' => ['class' => 'form-trans-language'],
                )
            )
            ->add(
                'message',
                TextType::class,
                array(
                    'attr' => ['class' => 'form-trans-message'],
                )
            );
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'attr' => [
                    'class' => 'sub-form-inline',
                ],
                'data_class' => PasswordPolicyTranslations::class
            ]
        );
    }
}
