<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Sso\BackendBundle\Model\Form\PasswordPolicy;

/**
 * Class PasswordPoliciesType
 * @package Sso\BackendBundle\Form
 */
class PasswordPoliciesType extends AbstractType
{
    const BTN_LABEL_ADD = 'Add Error Translation';
    const BTN_LABEL_DELETE = 'Delete Error Translation';

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('policyId', HiddenType::class);
        $builder->add('title', TextType::class);
        $builder->add(
            'regEx',
            TextType::class,
            [
                'label' => 'Regular Expression',
                'required' => false,
            ]
        );
        $builder->add(
            'regexErrorMessages',
            CollectionType::class,
            [
                'entry_type' => PasswordPoliciesTranslationsType::class,
                'entry_options' => [
                    'label' => false,
                ],
                'allow_add' => true,
                'allow_delete' => true,
                'delete_empty' => true,
                'attr' => [
                    'data-btn-text-add' => self::BTN_LABEL_ADD,
                    'data-btn-text-delete' => self::BTN_LABEL_DELETE,
                ],
            ]
        );
        $builder->add(
            'passwordPolicyValidations',
            CollectionType::class,
            [
                'entry_type' => PasswordPolicyValidationsType::class,
                'entry_options' => [
                    'label' => false,
                ],
                'allow_add' => true,
                'allow_delete' => true,
                'delete_empty' => true,
                'attr' => [
                    'data-btn-text-add' => 'Add Regular Expression',
                    'data-btn-text-delete' => 'Delete Regular Expression',
                ],
            ]
        );
        $builder->add(
            'validityDuration',
            NumberType::class,
            [
                'label' => 'Validity (days)',
            ]
        );
        $builder->add(
            'validityDurationErrorMessages',
            CollectionType::class,
            [
                'entry_type' => PasswordPoliciesTranslationsType::class,
                'entry_options' => [
                    'label' => false,
                ],
                'allow_add' => true,
                'allow_delete' => true,
                'delete_empty' => true,
                'attr' => [
                    'data-btn-text-add' => self::BTN_LABEL_ADD,
                    'data-btn-text-delete' => self::BTN_LABEL_DELETE,
                ],
            ]
        );
        $builder->add(
            'historySize',
            NumberType::class,
            [
                'label' => 'Password History',
            ]
        );
        $builder->add(
            'historySizeErrorMessages',
            CollectionType::class,
            [
                'entry_type' => PasswordPoliciesTranslationsType::class,
                'entry_options' => [
                    'label' => false,
                ],
                'allow_add' => true,
                'allow_delete' => true,
                'delete_empty' => true,
                'attr' => [
                    'data-btn-text-add' => self::BTN_LABEL_ADD,
                    'data-btn-text-delete' => self::BTN_LABEL_DELETE,
                ],
            ]
        );
        $builder->add(
            'editDistance',
            NumberType::class,
            [
                'label' => 'Edit Distance',
            ]
        );
        $builder->add(
            'editDistanceErrorMessages',
            CollectionType::class,
            [
                'entry_type' => PasswordPoliciesTranslationsType::class,
                'entry_options' => [
                    'label' => false,
                ],
                'allow_add' => true,
                'allow_delete' => true,
                'delete_empty' => true,
                'attr' => [
                    'data-btn-text-add' => self::BTN_LABEL_ADD,
                    'data-btn-text-delete' => self::BTN_LABEL_DELETE,
                ],
            ]
        );
        $builder->add(
            'changeDelay',
            NumberType::class,
            [
                'label' => 'Change Delay (minutes)',
            ]
        );
        $builder->add(
            'changeDelayErrorMessages',
            CollectionType::class,
            [
                'entry_type' => PasswordPoliciesTranslationsType::class,
                'entry_options' => [
                    'label' => false,
                ],
                'allow_add' => true,
                'allow_delete' => true,
                'delete_empty' => true,
                'attr' => [
                    'data-btn-text-add' => self::BTN_LABEL_ADD,
                    'data-btn-text-delete' => self::BTN_LABEL_DELETE,
                ],
            ]
        );
        $builder->add('policyDescription', TextType::class);
        $builder->add(
            'default',
            CheckboxType::class,
            [
                'label' => 'Default Policy',
                'required' => false,
            ]
        );
        $builder->add(
            'errorMessages',
            CollectionType::class,
            [
                'entry_type' => PasswordPoliciesTranslationsType::class,
                'entry_options' => [
                    'label' => false,
                ],
                'allow_add' => true,
                'allow_delete' => true,
                'delete_empty' => true,
                'attr' => [
                    'data-btn-text-add' => self::BTN_LABEL_ADD,
                    'data-btn-text-delete' => self::BTN_LABEL_DELETE,
                ],
            ]
        );
        $builder->add(
            'submit',
            SubmitType::class,
            [
                'label' => 'Save Policy',
                'attr' => ['class' => 'btn btn-success'],
            ]
        );
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => PasswordPolicy::class
            ]
        );
    }
}
