<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Lexik\Bundle\FormFilterBundle\Filter\Form\Type as FilterType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormError;

/**
 * Class ServiceFilterType
 * @package Sso\BackendBundle\Form
 */
class ServiceFilterType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('ServiceId', FilterType\TextFilterType::class)
            ->add('ServiceType', FilterType\TextFilterType::class)
            ->add('ServiceController', FilterType\TextFilterType::class)
            ->add('ServiceAction', FilterType\TextFilterType::class)
            ->add('ServiceMapped2Group', FilterType\TextFilterType::class)
            ->add('Lastname', FilterType\TextFilterType::class);
        $listener = function (FormEvent $event) {
            // Is data empty?
            foreach ($event->getData() as $data) {
                if (is_array($data)) {
                    foreach ($data as $subData) {
                        if (!empty($subData)) {
                            return;
                        }
                    }
                } else {
                    if (!empty($data)) {
                        return;
                    }
                }
            }

            $event->getForm()->addError(new FormError('Filter empty'));
        };
        $builder->addEventListener(FormEvents::POST_BIND, $listener);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_servicefiltertype';
    }
}
