<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

/**
 * Class TokenType
 * @package Sso\BackendBundle\Form
 */
class TokenType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('ServiceToken')
            ->add('ServiceToken2Ip')
            ->add('AllowedCallsPerDay')
            ->add('ValidUntil', Type\DateType::class, [
                'years' => array_keys(array_fill(date('Y'), 30, true)),
            ])
            ->add('Blocked', 'choice', ['choices' => [0 => 'No', 1 => 'Yes']])
            ->add('accessRestricted', Type\CheckboxType::class, [
                'label' => 'API Access Restricted',
                'required' => false,
            ])
            ->add('Description');
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(['data_class' => 'Sso\WebserviceBundle\Entity\ServiceProvider\Type\Token']);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_token';
    }
}
