<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Lexik\Bundle\FormFilterBundle\Filter\Form\Type as FilterType;
use Sso\BackendBundle\Model\Form\Application as ApplicationFormModel;
use Sso\WebserviceBundle\Entity\Webservice\Type\Application;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormError;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;

/**
 * Class WsApplicationAttributeFilterType
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\BackendBundle\Form
 */
class WsApplicationAttributeFilterType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('Id', FilterType\TextFilterType::class);
        $builder->add('Name', FilterType\TextFilterType::class);
        $builder->add('Type', FilterType\ChoiceFilterType::class, [
            'required' => false,
            'choices' => [
                "one" => "One",
                "many" => "Many",
            ],
        ]);
        $builder->add('Application', WsApplicationRelationFilterType::class);

        $listener = function (FormEvent $event) {
            // Is data empty?
            foreach ($event->getData() as $data) {
                if (is_array($data)) {
                    foreach ($data as $subData) {
                        if (!empty($subData)) {
                            return;
                        }
                    }
                } else {
                    if (!empty($data)) {
                        return;
                    }
                }
            }

            $event->getForm()->addError(new FormError('Filter empty'));
        };
        $builder->addEventListener(FormEvents::POST_BIND, $listener);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_webserviceapplicationattributesfiltertype';
    }
}
