<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;

/**
 * Class WsUserApplications
 * @package Sso\BackendBundle\Form
 */
class WsUserApplications extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->setAttribute('role', 'form')
            ->add('Applications', ChoiceType::class, array('attr' => array('class' => 'searchApplications'), 'multiple' => true))
            ->add('submit', 'submit', array('label' => 'Save'));

        // As choices are not set in here, validation has to be removed
        $builder->get('Applications')->resetViewTransformers();
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_wsauserpplications';
    }
}
