<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Sso\BackendBundle\Model\Form\UserCsvConfiguration;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Class WsUserCsvConfigurationType
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\BackendBundle\Form
 */
class WsUserCsvConfigurationType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $passwordEncryptTypeChoiceList = $options['password_encrypt_type_choices'];

        $builder->setMethod('POST');

        $builder->add('id', Type\HiddenType::class);

        $builder->add('columnDelimiter', Type\ChoiceType::class, [
            'choices' => [
                ';' => '; - Semicolon',
                ',' => ', - Comma',
            ],
            'expanded' => true,
            'required' => true,
        ]);

        $builder->add('textEnclosure', Type\ChoiceType::class, [
            'choices' => [
                '"' => '" - Double Quotes',
                '\'' => '\' - Single Quote',
            ],
            'expanded' => true,
            'required' => true,
        ]);

        $builder->add('encryptType', Type\ChoiceType::class, [
            'choices' => array_combine($passwordEncryptTypeChoiceList, $passwordEncryptTypeChoiceList),
            'expanded' => true,
            'required' => true,
        ]);

        $builder->add('autoCreateUser', Type\CheckboxType::class, [
            'required' => false,
        ]);

        $builder->add('activateCreatedUser', Type\CheckboxType::class, [
            'required' => false,
        ]);

        $builder->add('rows', Type\CollectionType::class, [
            'label' => 'Column Configuration',
            'allow_add' => true,
            'allow_delete' => true,
            'prototype' => true,
            'attr' => ['class' => 'form-collection'],
            'entry_type' => WsUserCsvRowType::class,
        ]);
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'password_encrypt_type_choices' => [],
                'data_class' => UserCsvConfiguration::class,
            ]
        );
    }
}
