<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\BackendBundle\Model\Form;

use Symfony\Component\Form\ChoiceList\View\ChoiceView;

/**
 * Class Application
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\BackendBundle\Model\Form
 */
class Application
{
    /**
     * Sort list of applications by label
     *
     * @param ChoiceView $a
     * @param ChoiceView $b
     * @return int
     */
    public static function compare(ChoiceView $a, ChoiceView $b)
    {
        return strcasecmp($a->label, $b->label);
    }
}
