<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\BackendBundle\Model\Form;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ApplicationAttributeOption
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\BackendBundle\Model\Form
 */
class ApplicationAttributeOption
{
    /**
     * @Assert\NotBlank()
     * @var string|null
     */
    private $label;

    /**
     * @Assert\NotBlank()
     * @var string|null
     */
    private $value;

    /**
     * @param string $label
     * @param string $value
     * @return ApplicationAttributeOption
     */
    public static function create(string $label, string $value): ApplicationAttributeOption
    {
        $option = new self;
        $option->setLabel($label);
        $option->setValue($value);
        return $option;
    }

    /**
     * @return string|null
     */
    public function getLabel(): ?string
    {
        return $this->label;
    }

    /**
     * @param string|null $label
     */
    public function setLabel(?string $label): void
    {
        $this->label = $label;
    }

    /**
     * @return string|null
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * @param string|null $value
     */
    public function setValue(?string $value): void
    {
        $this->value = $value;
    }
}
