<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\BackendBundle\Model\Form;

use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Context\ExecutionContextInterface;

/**
 * Class UserCsvRow
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\BackendBundle\Model\Form
 */
class UserCsvRow
{
    /**
     * @Assert\NotBlank()
     * @var string|null
     */
    private $targetEntity;

    /**
     * @Assert\NotNull()
     * @var int|null
     */
    private $rowId = 0;

    /**
     * @Assert\Valid()
     * @var UserCsvRowUser|null
     */
    private $user;

    /**
     * @Assert\Valid()
     * @var UserCsvRowApplicationAttribute|null
     */
    private $applicationAttribute;

    /**
     * @Assert\Valid()
     * @var UserCsvRowApplicationRole|null
     */
    private $applicationRole;

    /**
     * @return string|null
     */
    public function getTargetEntity(): ?string
    {
        return $this->targetEntity;
    }

    /**
     * @param string|null $targetEntity
     */
    public function setTargetEntity(?string $targetEntity): void
    {
        $this->targetEntity = $targetEntity;
    }

    /**
     * @return int|null
     */
    public function getRowId(): ?int
    {
        return $this->rowId;
    }

    /**
     * @param int|null $rowId
     */
    public function setRowId(?int $rowId): void
    {
        $this->rowId = $rowId;
    }

    /**
     * @return UserCsvRowUser|null
     */
    public function getUser(): ?UserCsvRowUser
    {
        return $this->user;
    }

    /**
     * @param UserCsvRowUser|null $user
     */
    public function setUser(?UserCsvRowUser $user): void
    {
        $this->user = $user;
    }

    /**
     * @return UserCsvRowApplicationAttribute|null
     */
    public function getApplicationAttribute(): ?UserCsvRowApplicationAttribute
    {
        return $this->applicationAttribute;
    }

    /**
     * @param UserCsvRowApplicationAttribute|null $applicationAttribute
     */
    public function setApplicationAttribute(?UserCsvRowApplicationAttribute $applicationAttribute): void
    {
        $this->applicationAttribute = $applicationAttribute;
    }

    /**
     * @return UserCsvRowApplicationRole|null
     */
    public function getApplicationRole(): ?UserCsvRowApplicationRole
    {
        return $this->applicationRole;
    }

    /**
     * @param UserCsvRowApplicationRole|null $applicationRole
     */
    public function setApplicationRole(?UserCsvRowApplicationRole $applicationRole): void
    {
        $this->applicationRole = $applicationRole;
    }
}
