<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\BackendBundle\Model\Form;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class UserCsvRowUser
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\BackendBundle\Model\Form
 */
class UserCsvRowUser
{
    /**
     * @Assert\NotNull()
     * @var string|null
     */
    private $userProperty;

    /**
     * @var bool|null
     */
    private $primaryKey;

    /**
     * @return string|null
     */
    public function getUserProperty(): ?string
    {
        return $this->userProperty;
    }

    /**
     * @param string|null $userProperty
     */
    public function setUserProperty(?string $userProperty): void
    {
        $this->userProperty = $userProperty;

        // Guid cannot be changed - so always primary key
        if ('guid' === $userProperty) {
            $this->primaryKey = true;
        }
    }

    /**
     * @return bool|null
     */
    public function getPrimaryKey(): ?bool
    {
        return $this->primaryKey;
    }

    /**
     * @param bool|null $primaryKey
     */
    public function setPrimaryKey(?bool $primaryKey): void
    {
        $this->primaryKey = $primaryKey;
    }
}
