<?php

/**
 * override the fos user controller because of saml
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\BackendSecurityBundle\Controller;

use FOS\UserBundle\Controller\SecurityController as BaseController;

/**
 * Class SecurityController
 * @package Sso\BackendSecurityBundle\Controller
 */
class SecurityController extends BaseController
{
    /**
     * @param \Symfony\Component\HttpFoundation\Request $request
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|\Symfony\Component\HttpFoundation\Response
     */
    public function loginAction(\Symfony\Component\HttpFoundation\Request $request){

        //check if saml activated of not redirect to backend!
        if(1 != getenv('DISABLE_SSO_LOGIN')){
            return $this->redirectToRoute('_admin_backend_index');
        }
        return parent::loginAction($request);
    }

}
