<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2018 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * Class PasswordPolicyController
 * @package Sso\DemoBundle\Controller
 */
class PasswordPolicyController extends BaseController
{
    /**
     * @Route("/", name="_sso_demo_password_policy_show")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function showAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion',
                'choice', [
                    'choices' => [
                        2 => 'Version 2',
                        3 => 'Version 3',
                    ],
                ])
            ->add('Identifier', 'text')
            ->add('PolicyId', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'PasswordPolicy', 'Show');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function xmlPasswordPolicyShow($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <PasswordPolicy>
                            <Show>
                                <Key>
                                    " . (strlen($params['Identifier']) ? "<UserType>" . $this->xmlBuildUserIdentifier($params) . "</UserType>" : "") . "
                                    " . (strlen($params['PolicyId']) ? "<PasswordPolicyType><PolicyId>" . $params['PolicyId'] . "</PolicyId></PasswordPolicyType>" : "") . "
                                </Key>
                            </Show>
                        </PasswordPolicy>
                    </SsoRequest>";
    }
}
